<?php

use yii\helpers\Html;
use app\models\User;
use yii\bootstrap\ActiveForm;


$this->title = $topic->name;

?>
    <div class="center mt4 feedback"><a href="/forum">
            Новости
        </a> / <?php echo Html:: encode($topic->name); ?> </div>


    <div class="bordered mt4" style="text-align:left;"><span style="float: right;">  <font size="1"
                                                                                           color="grey"> <?php echo $topic->time; ?></font></span>
        <?php echo User:: findUser($topic->user); ?> : <br>

        <br>
        <span style="margin-top:15px;color: #9edcdb;font-size:100%;">
  <?php echo nl2br($topic->user == 2 ? trim($topic->text) : \app\models\active\Smile:: View($topic->text)); ?>
  </span>
    </div>
    <div class="bordered">
        Топик: <?php echo $topic->close == 0 ? 'Открыт' : 'Закрыт'; ?>

        <?php if (Yii::$app->user->id == $topic->user || Yii::$app->user->identity->role > 0): ?>

            <a href="/forum/topic-close?id=<?php echo $topic->id; ?>">[<?php echo $topic->close == 1 ? 'Открыть' : 'Закрыть'; ?>
                ]</a>

        <?php endif; ?>

        <?php if (Yii::$app->user->identity->role > 0): ?>
            <br>
            <a href="/admin/edit-topic?id=<?php echo $topic->id; ?>"> Редактировать</a>
            <br>
            <a href="/admin/del-topic?id=<?php echo $topic->id; ?>"> Удалить</a>
        <?php endif; ?>

    </div>

<?php if ($topic->close == 0): ?>

    <div class="bordered center">
        <?php foreach ($emojihead as $emh): ?>
            <a href="javascript:void(0);" class="label" onclick="Emoji('<?php echo $emh['name']; ?>');"><img
                        src="/images/smiles/<?php echo $emh['img']; ?>.gif"></a>
        <?php endforeach; ?>
    </div>
    <div class="bordered" style="text-align:left;">


        <?php $form = ActiveForm::begin(['id' => 'login-form', 'fieldConfig' => [
            'template' => '{label}<br><div class="center">{input}</div>
			<div class="p5 alert">{error}</div>',
        ]]); ?>

        <?= $form->field($model, 'text')->textArea(['class' => 'form-control message-input'])->label('') ?>

        <?= Html::submitButton('Отправить', ['class' => 'btn btn-success']) ?>


        <a class="btn btn-success" onclick="EmojiPanel();"><i class="fa fa-smile-o"></i></a>

        <p class="fff center emojy">


            <?php foreach ($emoji as $em): ?>
                <a href="javascript:void(0);" class="label" onclick="Emoji('<?php echo $em['name']; ?>');"><img
                            src="/images/smiles/<?php echo $em['img']; ?>.gif"></a>
            <?php endforeach; ?>

        </p>

        <?php ActiveForm::end(); ?>


    </div>
<?php endif; ?>


<?php if ($count == 0): ?>

    <div class="bordered"> Нет комментариев</div>

<?php endif; ?>

<?php foreach ($all as $res): ?>


    <div class="bordered" style="text-align:left;">
        <?php echo User:: findUser($res['user']); ?>:
        <?php if ($res['user'] != Yii::$app->user->id): ?>
            <img src="/images/icons/reply.png" width="16" class="reply" style="cursor:pointer;"
                 onclick="reply('<?php echo User:: findOne($res['user'])->username ?? 'Гость' . $res['user']; ?>','<?php echo $res['user']; ?>');">
        <?php endif; ?>

        <span style="float: right;">  <font size="1" color="grey"> <?php echo $res['time']; ?></font>

	<?php if (Yii::$app->user->identity->role > 0): ?>
        <a href="/admin/delete-post?id=<?php echo $res['id']; ?>">
			    <i class="fa fa-trash"></i>
			</a>
    <?php endif; ?>


</span>
        <br>
        <span style="margin-top:25px;color: #9edcdb;font-size:100%;">
        <?php echo \app\models\active\Smile:: View($res['text']); ?></div>
    </span>

    </div>
<?php endforeach; ?>

    <div class="center">
        <?= \yii\widgets\LinkPager::widget(['pagination' => $pagination,
        ]) ?>
    </div>


    <div class="content">
        <div class="blocks">
            <a href="/forum" class="btnl mt4">
                <img src="/images/header/arrow_left_white2.png" width="24"> Вернуться
            </a>
        </div>
    </div>

<?php
$script = <<< JS


	function Emoji(smile)
	{
		var text = $('.message-input').val();

		$('.message-input').val(text+' '+smile);
		$('.message-input').focus();
	}

	function EmojiPanel()
	{

		if ($(".emojy").is(":hidden")) {
            $(".emojy").fadeIn(500);
        } else {
            $(".emojy").fadeOut();
        }


	}

		function reply(user,id)
	{

		$('.message-input').val(user+', ');
		$('.message-input').focus();

		const url = new URL(window.location);

		url.searchParams.set('reply', id);

		history.pushState(null, null, url);
	}


JS;

$this->registerJs($script, $this::POS_END);
